package finki.paw5.model.entities;

import finki.paw5.model.enumerations.FreeTime;
import finki.paw5.model.enumerations.Funds;
import finki.paw5.model.enumerations.Housing;
import finki.paw5.model.enumerations.PhysicalActivity;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDate;

@Data
@Entity
@Table(name = "adopter")
@PrimaryKeyJoinColumn(name = "id_user")
public class Adopter extends User {

    @Column(name = "free_time")
    private FreeTime freeTime;

    @Column(name = "funds")
    private Funds funds;

    @Column(name = "has_other_pets")
    private boolean hasOtherPets;

    @Column(name = "has_kids")
    private boolean hasKids;

    @Column(name = "housing")
    private Housing housing;

    @Column(name = "physical_activity_adopters")
    private PhysicalActivity physicalActivity;

    @Column(name = "will_foster")
    private boolean willFoster;

    @Column(name = "is_verified", nullable = false)
    private boolean verified;

    @Column(name = "verified_by_employee")
    private Integer verifiedByEmployeeId;

    public Adopter(LocalDate dateCreated, String name, String email, String password, String telephone,
                   FreeTime freeTime, Funds funds, boolean hasOtherPets, boolean hasKids, Housing housing,
                   PhysicalActivity physicalActivity, boolean willFoster, boolean verified) {
        super(dateCreated, name, email, password, telephone);
        this.freeTime = freeTime;
        this.funds = funds;
        this.hasOtherPets = hasOtherPets;
        this.hasKids = hasKids;
        this.housing = housing;
        this.physicalActivity = physicalActivity;
        this.willFoster = willFoster;
        this.verified = verified;
    }

    public Adopter(FreeTime freeTime, Funds funds, boolean hasOtherPets, boolean hasKids, Housing housing,
                   PhysicalActivity physicalActivity, boolean willFoster, boolean verified, int verifiedByEmployeeId) {
        this.freeTime = freeTime;
        this.funds = funds;
        this.hasOtherPets = hasOtherPets;
        this.hasKids = hasKids;
        this.housing = housing;
        this.physicalActivity = physicalActivity;
        this.willFoster = willFoster;
        this.verified = verified;
        this.verifiedByEmployeeId = verifiedByEmployeeId;
    }

    public Adopter() {
    }
}
